<?php

use App\Models\Order;

if(!function_exists('formatMoney'))
{
    // formats money to a whole number or with 2 decimals; includes a dollar sign in front
    function formatMoney($number, $cents = 1) { // cents: 0=never, 1=if needed, 2=always
        if (is_numeric($number)) { // a number
            if (!$number) { // zero
            $money = ($cents == 2 ? '0.00' : '0'); // output zero
            } else { // value
            if (floor($number) == $number) { // whole number
                $money = number_format($number, ($cents == 2 ? 2 : 0)); // format
            } else { // cents
                $money = number_format(round($number, 2), ($cents == 0 ? 0 : 2)); // format
            } // integer or decimal
            } // value
            return $money;
        } // numeric
    } // formatMoney
}

if(!function_exists('generateRandomString'))
{
    function generateRandomString($length = 6) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}

if(!function_exists('count_status_dashboard'))
{
    function count_status_dashboard($status)
    {
        return Order::where('order_status_id', $status)->count();
    }
}

