<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use App\Models\LogReport;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use App\Http\Controllers\Controller;
use App\Models\Affiliate;
use App\Models\UserDetail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\Rules\Password;

class SignUpController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('auth.sign-up');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required',
            'nric_number' => 'required',
            'phone_number' => 'required',
            'email' => 'required|email|unique:users,email',
            'introducer' => 'required',
            'username' => 'required|unique:users,username',
            'password' => [
                'required',
                'string',
                Password::min(8)
                    ->mixedCase()
                    ->numbers()
                    ->symbols(),
                'confirmed'
            ], 
            'password_confirmation' => 'required',
            'toc' => 'accepted',
        ]);


        $user = User::create([
            'name' => $request->name,
            'nric_number' => $request->nric_number,
            'phone_number' => $request->phone_number,
            'email' =>$request->email,
            'introducer_id' => random_int(100000, 999999),
            'username' => $request->username,
            'password' =>Hash::make($request->password),
            'avatar' => 'blank.png'
        ]);

        $user = UserDetail::create([
            'user_id' => $user->id,
            'bank_id' => 1
        ]);

        
        $user->assignRole('agent');

        $parent = User::where('introducer_id', $request->introducer)->get();

        Affiliate::create([
            'parent' => $parent[0]->id,
            'user_id' => $user->id,
        ]); 

        LogReport::create([
            'user_id' => $user->id,
            'module' => 'Registration',
            'ref_id' => $user->id,
            'details' => $user->name.' submit form of registration'
        ]); 

        LogReport::create([
            'user_id' => $user->id,
            'module' => 'Afiliate',
            'ref_id' => $user->id,
            'details' => $user->name.' downline to '.$parent->id
        ]); 

        $data = array(
            'name' => $request->username,
        );

        Mail::send('mail.welcome', $data, function($message) use($request){
            $message->to($request->email);
            $message->subject('Registration Successful');
        });


        return redirect()->route('sign-up-success', $user->id)->with('success', 'Your registration is successful.'); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function success($id)
    {        
        $row = User::find($id);

        return view('auth.success', [
            'username' => $row->username
        ]);
    }

    public function get_introducer_id(Request $request)
    {
        $introducer = $request->introducer;

        if(User::where('introducer_id', $introducer)->exists())
        {
            $status = 1;
            $data = User::where('introducer_id', $introducer)->get();
        }
        else
        {
            $status = 0;
        }

        return response()->json(['status'=>$status]);
        
    }
}
