<?php

namespace App\Http\Controllers;

use App\Models\Affiliate;
use App\Models\Order;
use App\Models\Package;
use App\Models\User;
use DataTables;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $packages = Package::all();

        $agent = User::findorfail(Auth::user()->id);
        $parent_id = Affiliate::where('user_id', Auth::user()->id)->select('parent')->get();

        $parent = User::findorfail($parent_id);

        $order = Order::where('user_id', Auth::user()->id)->first();

        $pending_orders = Order::where('order_status_id', 1)->get();
       
        return view('dashboard.dashboard',[
            'packages' => $packages,
            'agent' => $agent,
            'parent' => $parent,
            'order' => $order,
            'route' => request()->route()->getName(),
            'pending_orders' => $pending_orders
        ]);
    }

    
}
