<?php

namespace App\Http\Controllers\Trans;

use DataTables;
use App\Models\Order;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class TransactionController extends Controller
{
    public function out(Request $request)
    {
        $data = Order::where('order_status_id', 2)->where('user_id', Auth::user()->id)->get();

        if ($request->ajax()) {
            return Datatables::of($data)
                ->addIndexColumn()   
                ->addColumn('order_id', function($data){

                    return ' <span class="text-gray-800 text-hover-primary fw-bold">'.$data->code.'</span>';
                })    
                ->addColumn('agent', function($data){
                            
                    return '<span class="text-gray-800 text-hover-primary mb-1"">'.$data->user->name.'</span>';
                    
                }) 
                ->addColumn('package', function($data){

                    return '<span class="fw-bold">'.$data->order_packages[0]->position.'</span>';
                
                })  
                ->addColumn('total', function($data){

                    return '<span class="fw-bold">RM '.$data->payment_amt_rm.'</span>';
                }) 
                ->addColumn('payment_method', function($data){

                    return '<span class="fw-bold">'.ucfirst($data->payment_method).'</span>';
                })  
                ->addColumn('payment_date', function($data){

                    return '<span class="fw-bold">'.date('d/m/Y', strtotime($data->payment_date)).'</span>';
           
                })  
                ->escapeColumns([])
                //->rawColumns(['action'])
                ->make(true);
        } 

        return view('trans.out'); 
    }

    public function in(Request $request)
    {
        $data = Order::where('order_status_id', 2)->get();
        
        if(Auth::user()->getRoleNames()->implode(',') == 'agent')
        {

        }
        else
        {
            if ($request->ajax()) {
                return Datatables::of($data)
                    ->addIndexColumn()   
                    ->addColumn('order_id', function($data){

                        return ' <span class="text-gray-800 text-hover-primary fw-bold">'.$data->code.'</span>';
                    })    
                    ->addColumn('agent', function($data){
                                
                        return '<span class="text-gray-800 text-hover-primary mb-1"">'.$data->user->name.'</span>';
                        
                    }) 
                    ->addColumn('package', function($data){

                        return '<span class="fw-bold">'.$data->order_packages[0]->position.'</span>';
                    
                    })  
                    ->addColumn('total', function($data){

                        return '<span class="fw-bold">RM '.$data->payment_amt_rm.'</span>';
                    }) 
                    ->addColumn('payment_method', function($data){

                        return '<span class="fw-bold">'.ucfirst($data->payment_method).'</span>';
                    })  
                    ->addColumn('payment_date', function($data){

                        return '<span class="fw-bold">'.date('d/m/Y', strtotime($data->payment_date)).'</span>';
            
                    })  
                    ->escapeColumns([])
                    //->rawColumns(['action'])
                    ->make(true);
            } 
        }

        return view('trans.in'); 
    }
}
