<?php

namespace App\Models;

use App\Models\PackageMonthlyAllowance;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Package extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = [
        'position',
        'iso',
        'ablv_rm',
        'shareholder_rm',
        'discount_percent',
        'contract',
        'legal_fee_rm',
        'abla_rm'
    ];

    public function allowances()
    {
        return $this->hasMany(PackageMonthlyAllowance::class);
    }
}
