<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUsernameToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('nric_number')->nullable();
            $table->string('phone_number')->nullable();
            $table->string('introducer_id')->nullable();
            $table->string('username')->unique()->after('email');
            $table->string('avatar')->default('blank.png');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('nric_number');
            $table->dropColumn('phone_number');
            $table->dropColumn('introducer_id');
            $table->dropColumn('username');
            $table->dropColumn('avatar');
        });
    }
}
