<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->string('position');
            $table->decimal('ablv_rm', 8, 2);
            $table->decimal('shareholder_rm', 8, 2)->nullable();
            $table->decimal('discount_percent', 8, 2)->nullable();
            $table->string('contract');
            $table->decimal('legal_fee_rm', 8, 2)->nullable();
            $table->decimal('abla_rm', 8, 2)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('packages');
    }
}
