<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('code');
            $table->foreignId('order_status_id');
            $table->string('user_id')->comment('agent yg submit order');
            $table->decimal('total_rm', 8,2);
            $table->string('payment_method')->nullable();
            $table->date('payment_date')->nullable();
            $table->text('payment_comment')->nullable();
            $table->decimal('payment_amt_rm', 8,2)->nullable();
            $table->decimal('abla_amt', 8,2)->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->integer('delete_user')->nullable();
            $table->text('delete_comment')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
