{{-- Extends layout --}}
@extends('index')

{{-- Content --}}
@section('content')

<!--begin::Toolbar-->
<div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
    <!--begin::Toolbar container-->
    <div id="kt_app_toolbar_container" class="app-container container-xxl d-flex flex-stack">
        <!--begin::Page title-->
        <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
            <!--begin::Title--> 
            <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">My Profile</h1>
            <!--end::Title-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('dashboard') }}" class="text-muted text-hover-primary">Home</a>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-400 w-5px h-2px"></span>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">Profile</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
        
    </div>
    <!--end::Toolbar container-->
</div>
<!--end::Toolbar-->

<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
	<div id="kt_app_content_container" class="app-container container-xxl">
        <!--begin::Basic info-->
        <div class="card mb-5 mb-xl-10">
            <!--begin::Card header-->
            <div class="card-header border-0 cursor-pointer" role="button" data-bs-toggle="collapse" data-bs-target="#kt_account_profile_details" aria-expanded="true" aria-controls="kt_account_profile_details">
                <!--begin::Card title-->
                <div class="card-title m-0">
                    <h3 class="fw-bold m-0">Bank Details</h3>
                </div>
                <!--end::Card title-->
            </div>
            <!--begin::Card header-->
            <!--begin::Content-->
            <div id="kt_account_settings_profile_details" class="collapse show">
                <!--begin::Form-->
                <form action="{{ route('update-bank', Auth::user()->id)}}" method="POST" id="kt_account_profile_details_form" class="form">
                @csrf 
    
                    @if(session('success')) 
                    <script>
                    $(document).ready(function(){
                        swal.fire({
                            title: "DONE!",
                            text: "{{ session('success') }}",
                            icon: "success",
                            timer: 2500,
                            showConfirmButton: false
                        });
                    });
                    
                    </script> 
                    @endif

                    @if ($errors->any())
                        <script>
                        $(document).ready(function(){
                            swal.fire({
                                title: "Warning!",
                                text: "Please check your input.",
                                icon: "warning",
                                timer: 2500,
                                showConfirmButton: false
                            });
                        });
                        
                        </script> 
                    @endif
                    <!--begin::Card body-->
                    <div class="card-body border-top p-9">
                    
                        <!--begin::Input group-->
                        <div class="row mb-6">
                            <!--begin::Label-->
                            <label class="col-lg-4 col-form-label required fw-bold fs-6 required">Bank</label>
                            <!--end::Label-->
                            <!--begin::Col-->
                            <div class="col-lg-8">
                                <!--begin::Row-->
                                <div class="row">
                                    <!--begin::Input-->
                                    <select name="bank" id="bank" class="form-select  @error('bank') is-invalid @enderror form-select-lg form-select-solid  mb-3 mb-lg-0" 
                                            data-control="select2" data-placeholder="Select Bank" data-allow-clear="true" data-hide-search="true">
                                        <option></option>

                                        @foreach($banks as $value)
                                            <option value="{{ $value->id }}" {{old('bank',Auth::user()->user_details->bank_id)==$value->id ? 'selected' : ''}}>{{ $value->name }}</option>
                                        @endforeach
                                    </select>
                                    <!--end::Input-->

                                    @error('bank')
                                        <span class="form-text text-danger">{{$message}}</span>
                                    @enderror
                                </div>
                                <!--end::Row-->
                            </div>
                            <!--end::Col-->
                        </div>
                        <!--end::Input group-->
                

                        <div class="form-group row mb-6">
                            <label class="col-lg-4 col-form-label fw-bold fs-6 required">Account Number</label>
                            <div class="col-lg-8 fv-row">
                                
                                <input type="text" class="form-control @error('account_number') is-invalid @enderror form-control-solid" name="account_number" placeholder="" 
                                            oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1');"
                                            value="{{ old('account_number', Auth::user()->user_details->account_number) }}" />

                                @error('account_number')
                                    <span class="form-text text-danger">{{$message}}</span>
                                @enderror
                            </div>
                        </div>
                        
                    
                        <div class="form-group row mb-6">
                            <label class="col-lg-4 col-form-label fw-bold fs-6">Beneficiary Name</label>
                            <div class="col-lg-8 fv-row">

                                <input type="text" class="form-control @error('beneficiary_name') is-invalid @enderror form-control-solid" name="beneficiary_name" placeholder="" 
                                            value="{{ old('beneficiary_name', Auth::user()->user_details->beneficiary_name) }}" />

                                @error('beneficiary_name') 
                                    <span class="form-text text-danger">{{$message}}</span>
                                @enderror 
                            </div>
                        </div>
                    
            
                    </div>
                    <!--end::Card body-->
                    <!--begin::Actions-->
                    <div class="card-footer d-flex justify-content-end py-6 px-9">
                        <button type="reset" class="btn btn-light btn-active-light-primary me-2">Discard</button>
                        <button type="submit" class="button btn btn-primary" id="kt_account_profile_details_submit"
                            onclick="this.classList.toggle('button--loading')">
                            <span class="button__text">Save Changes</span></button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Basic info-->
        </div>
    <!--end::Content container-->
</div>
<!--end::Content-->
@endsection