{{-- Extends layout --}}
@extends('index')

{{-- Content --}}
@section('content')

<!--begin::Toolbar-->
<div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
    <!--begin::Toolbar container-->
    <div id="kt_app_toolbar_container" class="app-container container-xxl d-flex flex-stack">
        <!--begin::Page title-->
        <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
            <!--begin::Title--> 
            <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">Edit Order</h1>
            <!--end::Title-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('dashboard') }}" class="text-muted text-hover-primary">Home</a>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-400 w-5px h-2px"></span>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">Order</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
        <!--begin::Actions-->
        <div class="d-flex align-items-center gap-2 gap-lg-3">
            <!--begin::Button-->
            <a href="{{ route('index-order') }}" class="btn btn-secondary btn-sm ms-auto">
                <!--begin::Svg Icon | path: icons/duotune/arrows/arr074.svg-->
                <span class="svg-icon svg-icon-2">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.2657 11.4343L15.45 7.25C15.8642 6.83579 15.8642 6.16421 15.45 5.75C15.0358 5.33579 14.3642 5.33579 13.95 5.75L8.40712 11.2929C8.01659 11.6834 8.01659 12.3166 8.40712 12.7071L13.95 18.25C14.3642 18.6642 15.0358 18.6642 15.45 18.25C15.8642 17.8358 15.8642 17.1642 15.45 16.75L11.2657 12.5657C10.9533 12.2533 10.9533 11.7467 11.2657 11.4343Z" fill="currentColor" />
                    </svg>
                </span> Back
                <!--end::Svg Icon-->
            </a>
            <!--end::Button-->

           
        </div>
        <!--end::Actions-->
       
    </div>
    <!--end::Toolbar container-->
</div>
<!--end::Toolbar-->

<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
        <!--begin::Order details-->
        <div class="card card-flush py-4 mb-5">
            <!--begin::Card header-->
            <div class="card-header">
                <div class="card-title">
                    <h2>Payment Details</h2>
                </div>
            </div>
            <!--end::Card header-->
            <!--begin::Card body-->
            <div class="card-body pt-0">
                <div class="d-flex flex-column gap-10">
                    <!--begin::Input group-->
                    <div class="fv-row" id="errorScrollDiv">
                        <!--begin::Label-->
                        <label class="form-label">Order ID</label>
                        <!--end::Label-->
                        <!--begin::Auto-generated ID-->
                        <div class="fw-bold fs-3">#{{ $order->code }}</div>
                        <!--end::Input-->
                    </div>
                    <!--end::Input group-->
                    
                    <div class="row">
                        <!--begin::Input group-->
                        <div class="fv-row col-6">
                            <!--begin::Label-->
                            <label class="required form-label">Payment Date</label>
                            <!--end::Label-->
                            <!--begin::Editor-->
                            <input id="payment_date" name="payment_date" placeholder="Select a date" class="form-control" value="" />
                            <!--end::Editor-->
                            <!--begin::Description-->
                            <div class="text-muted fs-7">Set the payment date that has been made.</div>

                            <div class="text-danger fs-7 err_payment_date"></div>
                            <!--end::Description-->
                        </div>
                        <!--end::Input group-->

                        <!--begin::Input group-->
                        <div class="fv-row col-6">
                            <!--begin::Label-->
                            <label class="required form-label">Payment Method</label>
                            <!--end::Label-->
                            <!--begin::Select2-->
                            <select class="form-select" data-control="select2" data-hide-search="true" 
                                data-placeholder="Select an option" name="payment_method" id="payment_method">
                                <option value=""></option>
                                <option value="cod">Cash</option>
                                <option value="deposit">Deposit</option>
                                <option value="online">Online</option>
                            </select>
                            <!--end::Select2-->
                            <!--begin::Description-->
                            <!-- <div class="text-muted fs-7">Set the date of the order to process.</div> -->
                            <div class="text-danger fs-7 err_payment_method"></div>
                            <!--end::Description-->
                        </div>
                        <!--end::Input group-->
                    </div>

                    <div class="row">
                        <!--begin::Input group-->
                        <div class="fv-row col-6">
                            <!--begin::Label-->
                            <label class="required form-label">Amount of Payment</label>
                            <!--end::Label-->
                            <!--begin::Wrapper-->
                            <div class="position-relative d-flex align-items-center">
                                <!--begin::Icon-->
                                <div class="symbol symbol-20px me-4 position-absolute ms-4">
                                    RM
                                </div>
                                <!--end::Icon-->
                                <!--begin::Input-->
                                <input type="text" class="form-control ps-12" 
                                    name="amount_of_payment" id="amount_of_payment" placeholder=""
                                    onkeyup="this.value=this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1')"/>
                                <!--end::Input-->
                            </div>
                            <!--end::Wrapper-->
                        
                            <!--begin::Description-->
                            <!-- <div class="text-muted fs-7">Set the date of the order to process.</div> -->
                            <div class="text-danger fs-7 err_amount_of_payment"></div>
                            <!--end::Description-->
                        </div>
                        <!--end::Input group-->

                        <!--begin::Input group-->
                        <div class="fv-row col-6">
                            <!--begin::Label-->
                            <label class="required form-label">Advisor Business License Advance (ABLA)</label>
                            <!--end::Label-->
                            <!--begin::Wrapper-->
                            <div class="position-relative d-flex align-items-center">
                                <!--begin::Icon-->
                                <div class="symbol symbol-20px me-4 position-absolute ms-4">
                                    RM
                                </div>
                                <!--end::Icon-->
                                <!--begin::Input-->
                                <input type="text" class="form-control ps-12" 
                                    name="abla" id="abla" placeholder=""
                                    onkeyup="this.value=this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1')"/>
                                <!--end::Input-->
                            </div>
                            <!--end::Wrapper-->
                        
                            <!--begin::Description-->
                            <!-- <div class="text-muted fs-7">Set the date of the order to process.</div> -->
                            <div class="text-danger fs-7 err_abla"></div>
                            <!--end::Description-->
                        </div>
                        <!--end::Input group-->
                    </div>

                    <!--begin::Input group-->
                    <div class="fv-row">
                        <!--begin::Label-->
                        <label class="form-label">Comment</label>
                        <!--end::Label-->
                        <!--begin::Select2-->
                        <textarea class="form-control" name="comment" id="comment" rows="3"></textarea>
                        <!--end::Select2-->
                    
                        <!-- <div class="text-muted fs-7">This comment will appear in order history.</div> -->
                    </div>
                    <!--end::Input group-->
                </div>
            </div>
            <!--end::Card header-->
        </div>
        <!--end::Order details-->


        <!--begin::Actions-->
        <div class="d-flex flex-stack pt-5">
            <!--begin::Wrapper-->
            <div class="mr-2">
                <a href="{{ route('edit-order', $order->id) }}" class="btn btn-secondary me-5" >
                Previous</a>
            </div>
            <!--end::Wrapper-->
            <!--begin::Wrapper-->
            <div>
                <button type="button" id="btn_reject_order" class="button btn btn-danger me-5 "
                    onclick="this.classList.toggle('button--loading')">
                    <span class="button__text">Reject</span>
                </button>
                <button type="button" id="btn_approve_order" class="button btn btn-success"
                    onclick="this.classList.toggle('button--loading')">
                    <span class="button__text">Approve</span>
                </button>
            </div>
            <!--end::Wrapper-->
        </div>
        <!--end::Actions-->
    </div>
</div>
       
@endsection

{{-- Scripts Section --}}

@section('scripts')
 
<script>
// Init flatpickr
    $('#payment_date').flatpickr({
        altInput: true,
        altFormat: "d F Y",
        dateFormat: "Y-m-d",
    });

    

    $('#btn_approve_order').on('click',function() {


        event.preventDefault();
        swal.fire({
            title: "Are you sure?",
            text: 'This action will approve the order.',
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, confirm!',
        })
        .then((result) => {
            if (result.isConfirmed) {
                var payment_date = $('#payment_date').val();
                var payment_method = $('#payment_method').val();
                var amount_of_payment = $('#amount_of_payment').val();
                var abla = $('#abla').val();
                var comment = $('#comment').val();
                
                $.ajax({
                    url: "{{ route('approve-order', $order->id) }}", 
                    type:"POST",
                    data:{
                        "_token": "{{ csrf_token() }}",
                        payment_date:payment_date,
                        payment_method:payment_method,
                        amount_of_payment:amount_of_payment,
                        abla:abla,
                        comment:comment
                    },
                    success:function(response){
                        $("#btn_approve_order").removeClass('button--loading');

                        console.log(response);
                        if(response.success)
                        {
                            swal.fire({
                                title: "DONE!",
                                text: response.success,
                                icon: "success",
                            }).then(function() {
                                location.href="{{ route('show-order', $order->id) }}";
                            });
                        }
                    
                    },
                    error: function(response) {
                        $("#btn_approve_order").removeClass('button--loading');

                        swal.fire({
                            title: "Warning!",
                            text: "Please check your input",
                            icon: "warning",
                            timer: 2500,
                            showConfirmButton: false
                        }).then(function() {
                            $('html, body').animate({
                                scrollTop: $("#errorScrollDiv").offset()
                                    .top - 130
                            }, 1000);
                        });

                        console.log(response);

                        $('.err_payment_date').text(response.responseJSON.errors.payment_date);
                        $('.err_payment_method').text(response.responseJSON.errors.payment_method);
                        $('.err_amount_of_payment').text(response.responseJSON.errors.amount_of_payment);
                        $('.err_abla').text(response.responseJSON.errors.abla);
                   
                    }
                });  
            }
            else
            {
                $("#btn_approve_order").removeClass('button--loading');

                $('.err_payment_date').text('');
                $('.err_payment_method').text('');
                $('.err_amount_of_payment').text('');
                $('.err_abla').text('');
            }
        }); 

            
    });

    $('#btn_reject_order').on('click',function() {

        event.preventDefault();
        swal.fire({
            title: "Are you sure?",
            text: 'This action will reject the order.',
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, confirm!',
        })
        .then((result) => {
            if (result.isConfirmed) {
                var payment_date = $('#payment_date').val();
                var payment_method = $('#payment_method').val();
                var amount_of_payment = $('#amount_of_payment').val();
                var abla = $('#abla').val();
                var comment = $('#comment').val();
                
                $.ajax({
                    url: "{{ route('reject-order', $order->id) }}", 
                    type:"POST",
                    data:{
                        "_token": "{{ csrf_token() }}",
                        payment_date:payment_date,
                        payment_method:payment_method,
                        amount_of_payment:amount_of_payment,
                        abla:abla,
                        comment:comment
                    },
                    success:function(response){
                        $("#btn_reject_order").removeClass('button--loading');

                        console.log(response);
                        if(response.success)
                        {
                            swal.fire({
                                title: "DONE!",
                                text: response.success,
                                icon: "success",
                            }).then(function() {
                                location.href="{{ route('show-order', $order->id) }}";
                            });
                        }
                    
                    },
                    error: function(response) {
                        $("#btn_reject_order").removeClass('button--loading');

                        swal.fire({
                            title: "Warning!",
                            text: "Please check your input",
                            icon: "warning",
                            timer: 2500,
                            showConfirmButton: false
                        }).then(function() {
                            $('html, body').animate({
                                scrollTop: $("#errorScrollDiv").offset()
                                    .top - 130
                            }, 1000);
                        });

                        console.log(response);

                        $('.err_payment_date').text(response.responseJSON.errors.payment_date);
                        $('.err_payment_method').text(response.responseJSON.errors.payment_method);
                        $('.err_amount_of_payment').text(response.responseJSON.errors.amount_of_payment);
                        $('.err_abla').text(response.responseJSON.errors.abla);
                
                    }
                });  
            }
            else
            {
                $("#btn_reject_order").removeClass('button--loading');

                $('.err_payment_date').text('');
                $('.err_payment_method').text('');
                $('.err_amount_of_payment').text('');
                $('.err_abla').text('');
            }
        }); 

    
    });


</script>
@endsection