<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TestController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\LogoutController;
use App\Http\Controllers\Auth\SignUpController;
use App\Http\Controllers\Order\OrderController;
use App\Http\Controllers\Setting\UserController;
use App\Http\Controllers\Setting\AgentController;
use App\Http\Controllers\Auth\FirstLoginController;
use App\Http\Controllers\Trans\TransactionController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\AccountProfile\AccountProfileController;
use App\Http\Controllers\AccountProfile\ChangePasswordController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/', [LoginController::class,'index'])->name('login');
Route::get('/login', [LoginController::class,'index'])->name('login');
Route::post('/login', [LoginController::class, 'store'])->name('login-store');

Route::get('/sign-up', [SignUpController::class,'create'])->name('sign-up');
Route::post('/sign-up', [SignUpController::class,'store'])->name('sign-up-store');

Route::get('/{id}/success', [SignUpController::class,'success'])->name('sign-up-success');

Route::get('/get_introducer_id', [SignUpController::class,'get_introducer_id'])->name('get_introducer_id');

Route::get('/forgot-password', [ForgotPasswordController::class,'create'])->name('forgot-password');
Route::post('/forgot-password', [ForgotPasswordController::class,'store'])->name('forgot-password-store');

Route::get('/{token}/{id}/reset-password', [ResetPasswordController::class,'create'])->name('reset-password');
Route::post('/reset-password', [ResetPasswordController::class,'store'])->name('reset-password-store');

Route::get('/{token}/{id}/first-login', [FirstLoginController::class,'create'])->name('first-login');
Route::post('/first-login', [FirstLoginController::class,'store'])->name('first-login-store');

Route::middleware('auth')->group(function () {

    Route::get('/logout', [LogoutController::class,'store'])->name('logout');

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('/buy-package', [OrderController::class, 'buy_package'])->name('buy-package');

    Route::group(['prefix' => 'account'], function () {
        Route::get('/profile', [AccountProfileController::class, 'index'])->name('view-account');
        Route::get('/profile/{id}/edit', [AccountProfileController::class, 'edit'])->name('edit-account');
        Route::post('/profile/{id}/update', [AccountProfileController::class, 'update'])->name('update-account');

        Route::get('/{id}/bank', [AccountProfileController::class, 'edit_bank'])->name('edit-bank');
        Route::post('/{id}/bank', [AccountProfileController::class, 'update_bank'])->name('update-bank');        
    });

    Route::group(['prefix' => 'security'], function () {
        Route::get('/', [ChangePasswordController::class, 'edit'])->name('edit-password');
        Route::post('/update', [ChangePasswordController::class, 'update'])->name('update-password');
    });

    Route::group(['prefix' => 'order'], function () {
        Route::get('/', [OrderController::class, 'index'])->name('index-order');
        Route::get('/{id}/detail', [OrderController::class, 'show'])->name('show-order');
        Route::get('/{id}/edit', [OrderController::class, 'edit'])->name('edit-order');
        Route::post('/{id}/next', [OrderController::class, 'next'])->name('next-order');

        Route::get('/{id}/edit_payment', [OrderController::class, 'edit_payment'])->name('edit-payment-order');
        Route::post('/{id}/approve', [OrderController::class, 'approve'])->name('approve-order');
        Route::post('/{id}/reject', [OrderController::class, 'reject'])->name('reject-order');
    });

    Route::group(['prefix' => 'trans'], function () {
        Route::get('/in', [TransactionController::class, 'in'])->name('in-trans');
        Route::get('/out', [TransactionController::class, 'out'])->name('out-trans');
    });

    Route::group(['prefix' => 'user'], function () {
        Route::get('/', [UserController::class, 'index'])->name('index-user');
        Route::get('/create', [UserController::class, 'create'])->name('create-user');
        Route::post('/store', [UserController::class, 'store'])->name('store-user');

        
        Route::get('/{id}/edit', [UserController::class, 'edit'])->name('edit-user');
        Route::post('/{id}/update', [UserController::class, 'update'])->name('update-user');
    });

    Route::group(['prefix' => 'agent'], function () {
        Route::get('/', [AgentController::class, 'index'])->name('index-agent');
        Route::get('/create', [AgentController::class, 'create'])->name('create-agent');
        Route::post('/store', [AgentController::class, 'store'])->name('store-agent');

        Route::get('/{id}/detail', [AgentController::class, 'show'])->name('show-agent');
        Route::get('/{id}/edit', [AgentController::class, 'edit'])->name('edit-agent');
        Route::post('/{id}/update', [AgentController::class, 'update'])->name('update-agent');
    });
});

Route::get('/mail', function () {

  

    return view('mail.welcome', ['username' => 'zaty']);
});  

Route::get('/test_email', [TestController::class, 'test_email']);
Route::get('/add_order', [TestController::class, 'add_order']);
