<!DOCTYPE html>
<!--
Author: Keenthemes
Product Name: Metronic | Bootstrap HTML, VueJS, React, Angular, Asp.Net Core, Blazor, Django, Flask & Laravel Admin Dashboard Theme
Purchase: https://1.envato.market/EA4JP
Website: http://www.keenthemes.com
Contact: support@keenthemes.com
Follow: www.twitter.com/keenthemes
Dribbble: www.dribbble.com/keenthemes
Like: www.facebook.com/keenthemes
License: For each use you must have a valid license purchased only from above link in order to legally use the theme for your project.
-->
<html lang="en">
	<!--begin::Head-->
	<?php echo $__env->make('panel.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
	<!--end::Head-->
	<!--begin::Body-->
	<body id="kt_body" class="app-blank app-blank">
		<!--begin::Theme mode setup on page load-->
		<?php echo $__env->make('partials/theme-mode/_init', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!--end::Theme mode setup on page load-->
		<!--begin::Root-->
		<div class="d-flex flex-column flex-root" id="kt_app_root">
			<!--begin::Authentication - Sign-up -->
			<div class="d-flex flex-column flex-lg-row flex-column-fluid">
				<!--begin::Body-->
				<div class="d-flex flex-column flex-lg-row-fluid w-lg-50 p-10 order-2 order-lg-1">
					<!--begin::Form-->
					<div class="d-flex flex-center flex-column flex-lg-row-fluid">
						<!--begin::Wrapper-->
						<div class="w-lg-500px p-10">
							<!--begin::Form-->
							<form action="#" class="form w-100" novalidate="novalidate" id="kt_sign_up_form" method="POST" >

								<?php if(session('success')): ?> 
									<script>
									$(document).ready(function(){
										swal.fire({
											title: "DONE!",
											text: "<?php echo e(session('success')); ?>",
											icon: "success",
											timer: 2500,
											showConfirmButton: false
										});
									});
									</script>
								<?php endif; ?>


								<!--begin::Heading-->
								<div class="text-center mb-11">
									<!--begin::Title-->
									<h1 class="text-dark fw-bolder mb-3">Your registration is successful.</h1>
									<!--end::Title-->

									<!--begin:Media-->
									<div style="margin-bottom: 15px">
										<img alt="Logo" src="<?php echo e(asset('media/email/icon-positive-vote-1.svg')); ?>" />
									</div>
									<!--end:Media-->

									<!--begin::Subtitle-->
									<div class="text-gray-500 fw-semibold fs-6">Hey <?php echo e($username); ?>, thank you for joining us. Welcome to PFDIB System. 
										<br><br>Your account is ready, you can log in to your account by clicking the button below using your username and account password.</div>
									<!--end::Subtitle=-->
								</div>
								<!--begin::Heading-->
							


						
								<!--begin::Submit button-->
								<div class="d-grid">

									<a href="<?php echo e(route('login')); ?>" class="button btn btn-lg btn-primary" onclick="this.classList.toggle('button--loading')">
										<span class="button__text">Back to Login</span>
									</a>
								</div>
								<!--end::Submit button-->
							
							</form>
							<!--end::Form-->
						</div>
						<!--end::Wrapper-->
					</div>
					<!--end::Form-->
					<!--begin::Footer-->
					<div class="d-flex flex-center flex-wrap px-5">
						<!--begin::Links-->
						<div class="d-flex fw-semibold text-primary fs-base">
							<a href="../../demo1/dist/pages/team.html" class="px-5" target="_blank">Terms</a>
							<a href="../../demo1/dist/pages/pricing/column.html" class="px-5" target="_blank">Plans</a>
							<a href="../../demo1/dist/pages/contact.html" class="px-5" target="_blank">Contact Us</a>
						</div>
						<!--end::Links-->
					</div>
					<!--end::Footer-->
				</div>
				<!--end::Body-->
				<!--begin::Aside-->
				<?php echo $__env->make('auth.panel.aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
				<!--end::Aside-->
			</div>
			<!--end::Authentication - Sign-up-->
		</div>
		<!--end::Root-->

		<!--begin::Javascript-->
		<!--begin::Global Javascript Bundle(used by all pages)-->
		<?php echo $__env->make('auth.panel.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
		<!--end::Global Javascript Bundle-->
        
		
		<!--end::Javascript-->
	</body>
	<!--end::Body-->
</html><?php /**PATH C:\laragon\www\pfdib-system\resources\views/auth/success.blade.php ENDPATH**/ ?>