<?php

namespace App\Http\Controllers\AccountProfile;

use App\Models\Bank;
use App\Models\User;
use App\Models\State;
use App\Models\UserDetail;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AccountProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $bank_name = '';
        if(Auth::user()->user_details->bank->account_number != null)
        {
            $bank_name = '('.Auth::user()->user_details->bank->name.')';
        }
        return view('account-profile.profile.index', [
            'bank_name' => $bank_name
        ]); 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $states = State::all();


        return view('account-profile.profile.edit', [
            'states' => $states
        ]); 
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $user = User::findorfail($id);

        if($user->email ==  $request->email)
        {
            $val_data = $request->validate([
                'name' => 'required',
                'nric_number' => 'required',
                'phone_number' => 'required',
                'email' => 'required|email',
                'address' => 'required',
                'postcode' => 'required',
                'city' => 'required',
                'state' => 'required',
            ]);
        }
        else
        {
            $val_data = $request->validate([
                'name' => 'required',
                'nric_number' => 'required',
                'phone_number' => 'required',
                'email' => 'required|email|unique:users,email',
                'address' => 'required',
                'postcode' => 'required',
                'city' => 'required',
                'state' => 'required',
            ]);
        }
        

        if($request->avatar_remove == 1)
        {
            User::where('id', $id)
            ->update([
                'name' => $request->name,
                'nric_number' => $request->nric_number,
                'phone_number' => $request->phone_number,
                'email' =>$request->email,
                'avatar' => 'blank.png'
            ]);
        }
        else
        {

            if($request->file('avatar')) 
            { 
                $file = $request->file('avatar');
                $filename = time().'_'.$file->getClientOriginalName();

                // File extension
                $extension = $file->getClientOriginalExtension();

                // File upload location
                $location = 'media/avatars';

                // Upload file
                $file->move($location,$filename);
                
                // File path
                $filepath = url('media/avatars/'.$filename);

                // Response
                $data['success'] = 1;
                $data['message'] = 'Uploaded Successfully!';
                $data['filepath'] = $filepath;
                $data['extension'] = $extension;
                $data['filename'] = $filename;

                User::where('id', $id)
                ->update([
                    'name' => $request->name,
                    'nric_number' => $request->nric_number,
                    'phone_number' => $request->phone_number,
                    'email' =>$request->email,
                    'avatar' => $data['filename']
                ]);
                
            }
            else
            {
                User::where('id', $id)
                ->update([
                    'name' => $request->name,
                    'nric_number' => $request->nric_number,
                    'phone_number' => $request->phone_number,
                    'email' =>$request->email,
                ]); 

            }
        }

        UserDetail::where('user_id', $id)
        ->update([
            'address' =>$request->address,
            'postcode' =>$request->postcode,
            'city' =>$request->city,
            'state' =>$request->state
        ]);

        return redirect()->route('view-account')->with('success', 'Your profile has been updated.'); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function edit_bank($id)
    {
        $banks = Bank::all();

        return view('account-profile.bank.edit', [
            'banks' => $banks,
        ]); 
    }

    public function update_bank(Request $request, $id)
    {
        $val_data = $request->validate([
            'bank' =>'required',
            'account_number' =>'required',
            'beneficiary_name' =>'required'
        ]);

        UserDetail::where('user_id', $id)
        ->update([
            'bank_id' => $request->bank,
            'account_number' => $request->account_number,
            'beneficiary_name' => $request->beneficiary_name
        ]);

        return redirect()->route('view-account')->with('success', 'Your bank details has been updated.'); 


    }
}
