<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;

class ResetPasswordController extends Controller
{
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($token, $id)
    {
        return view('auth.reset-password', ['token' => $token,'id' => $id]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'password' => [
                'required',
                'string',
                Password::min(8)
                    ->mixedCase()
                    ->numbers()
                    ->symbols(),
                'confirmed'
            ],  
            'password_confirmation' => 'required',
      
        ]);

        $user = User::findOrFail($request->id);
      
        $updatePassword = DB::table('password_resets')
                            ->where(['email' => $user->email, 'token' => $request->token])
                            ->first();
      
        if(!$updatePassword)
            return back()->withInput()->with('error', 'Invalid token!');
      
        $user = User::where('id', $request->id)
                    ->update(['password' => Hash::make($request->password)]);
    
        DB::table('password_resets')->where(['email'=> $request->email])->delete();
    
        return redirect('/login')->with('success', 'Your password has been changed!');
    }
}
