<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Order;
use App\Models\Package;
use App\Models\LogReport;
use Illuminate\Support\Str;
use App\Models\Notification;
use App\Models\OrderHistory;
use App\Models\OrderPackage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class TestController extends Controller
{
    //

    public function test_email()
    {
        $user = User::findorfail(3);
 
         $token = Str::random(64);

        DB::table('password_resets')->insert([
            'email' => $user->email, 
            'token' => $token, 
            'created_at' => Carbon::now()
        ]);

        $data = array(
            'token' => $token,
            'username' => $user->name
        );
            
        Mail::send('mail.welcome', $data, function($message) use($user){
            $message->to($user->email);
            $message->subject('Registration Successfully');
        }); 

        return redirect()->route('index-user')->with('success', 'Registration Successfully!');
    }

    public function add_order()
    {
        $package = Package::findorfail(1);
        $user = User::findorfail(4);
        
        $order = Order::create([
            'code'=> generateRandomString(),
            'order_status_id' => 1,
            'user_id' => $user->id,
            'total_rm' => $package->ablv_rm
        ]);

        OrderPackage::create([
            'order_id' => $order->id,
            'package_id' => 1,
            'iso' => $package->iso,
            'position' => $package->position,
            'ablv_rm' => $package->ablv_rm,
            'shareholder_rm' => $package->shareholder_rm,
            'discount_percent' => $package->discount_percent,
            'contract' => $package->contract,
            'legal_fee_rm' => $package->legal_fee_rm,
        ]);

        OrderHistory::create([
            'order_id' => $order->id,
            'order_status_id' => 1,
            'notify' => 1,
            'comment' => 'Successfully submitted. Pending approval'
        ]);

        LogReport::create([
            'user_id' => Auth::user()->id,
            'module' => 'Order',
            'ref_id' => $order->id,
            'details' => Auth::user()->id.' submit order'
        ]); 

        Notification::create([
            'user_id' => 1,
            'reference_table' => 'orders',
            'reference_id' => $order->id,
            'module' => 'Order',
            'comment' => 'New order, approve this order',
            'status_name'=> 'Pending',
            'status_color' =>'warning'
        ]); 

        

        $data_agent = array(
            'name' => $user->user,
            'email' => $user->email,
            'order' => $order,
            'text1' => 'Thank you for your purchase!',
            'text2' => 'Please make payment within 48 hour.'
        );

        Mail::send('mail.new-order', $data_agent, function($message) use($data_agent){
            $message->to($data_agent['email']);
            $message->subject('New Order - '.$data_agent['order']->code);
        });

        $user = User::findorfail(1);

        $data_admin = array(
            'name' => Auth::user()->username,
            'email' => Auth::user()->email,
            'order' => $order,
            'text1' => 'New incoming order!',
            'text2' => 'You have new order, please approve the order'
        );

        Mail::send('mail.new-order', $data_admin, function($message) use($data_admin){
            $message->to($data_admin['email']);
            $message->subject('New Order - '.$data_admin['order']->code);
        });
    }
}
