<?php

namespace App\Models;

use App\Models\User;
use App\Models\OrderStatus;
use App\Models\OrderHistory;
use App\Models\OrderPackage;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Order extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = [
        'code',
        'order_status_id',
        'user_id',
        'total_rm',
        'payment_method',
        'payment_date',
        'payment_comment',
        'payment_amt_rm',
        'abla_amt',
        'delete_user',
        'delete_comment'
    ];

    public function order_packages()
    {
        return $this->hasMany(OrderPackage::class);
    }

    public function user()
    {
      return $this->belongsTo(User::class);
    }

    public function order_status()
    {
      return $this->belongsTo(OrderStatus::class);
    }

    public function order_historys()
    {
        return $this->hasMany(OrderHistory::class);
    }






}
