<?php

namespace App\Models;

use App\Models\Package;
use App\Models\UserStatus;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'nric_number',
        'phone_number',
        'introducer_id',
        'username',
        'package_id',
        'user_status_id'
    ];

    public function user_details()
    {
        return $this->hasOne(UserDetail::class);
    }

    public function user_status()
    {
        return $this->belongsTo(UserStatus::class);
    }

    public function package()
    {
        return $this->belongsTo(Package::class);
    }
    


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
}
