<?php

namespace App\Models;

use App\Models\Bank;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'address',
        'postcode',
        'city',
        'state',
        'bank_id',
        'account_number',
        'beneficiary_name',
    ];

    public function users()
    {
        return $this->belongsTo(User::class);
    }

    public function bank()
    {
      return $this->belongsTo(Bank::class);
    }
}
