<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrderPackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id');
            $table->foreignId('package_id');
            $table->string('iso');
            $table->string('position');
            $table->decimal('ablv_rm', 8, 2);
            $table->decimal('shareholder_rm', 8, 2)->nullable();
            $table->decimal('discount_percent', 8, 2)->nullable();
            $table->string('contract');
            $table->decimal('legal_fee_rm', 8, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_packages');
    }
}
