<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id');
            $table->foreignId('reference_id');
            $table->string('reference_table');
            $table->string('module')->comment('1=Pendaftaran, 2=Order');
            $table->text('comment')->nullable();
            $table->integer('view')->default(0)->comment('0=blom tgok, 1=dh tgok');
            $table->string('status_name');
            $table->string('status_color');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
}
