{{-- Extends layout --}}
@extends('index')

{{-- Content --}}
@section('content')
<!--begin::Toolbar-->
<div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
    <!--begin::Toolbar container-->
    <div id="kt_app_toolbar_container" class="app-container container-xxl d-flex flex-stack">
        <!--begin::Page title-->
        <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
            <!--begin::Title--> 
            <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">View Agent Details</h1>
            <!--end::Title-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('dashboard') }}" class="text-muted text-hover-primary">Home</a>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-400 w-5px h-2px"></span>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">Agent Management</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
         <!--begin::Actions-->
         <div class="d-flex align-items-center gap-2 gap-lg-3">
            <!--begin::Button-->
            <button type="button" onClick="history.go(-1);" class="btn btn-secondary btn-sm ms-auto">
                <!--begin::Svg Icon | path: icons/duotune/arrows/arr074.svg-->
                <span class="svg-icon svg-icon-2">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.2657 11.4343L15.45 7.25C15.8642 6.83579 15.8642 6.16421 15.45 5.75C15.0358 5.33579 14.3642 5.33579 13.95 5.75L8.40712 11.2929C8.01659 11.6834 8.01659 12.3166 8.40712 12.7071L13.95 18.25C14.3642 18.6642 15.0358 18.6642 15.45 18.25C15.8642 17.8358 15.8642 17.1642 15.45 16.75L11.2657 12.5657C10.9533 12.2533 10.9533 11.7467 11.2657 11.4343Z" fill="currentColor" />
                    </svg>
                </span> Back
                <!--end::Svg Icon-->
            </button>
            <!--end::Button-->

           
        </div>
        <!--end::Actions-->
       
    </div>
    <!--end::Toolbar container-->
</div>
<!--end::Toolbar-->

<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
        <!--begin::Contacts-->
        <div class="card card-flush h-lg-100" id="kt_contacts_main">
            <!--begin::Card header-->
            <div class="card-header pt-7" id="kt_chat_contacts_header">
                <!--begin::Card title-->
                <div class="card-title">
                    <!--begin::Svg Icon | path: icons/duotune/communication/com005.svg-->
                    <span class="svg-icon svg-icon-1 me-2">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M20 14H18V10H20C20.6 10 21 10.4 21 11V13C21 13.6 20.6 14 20 14ZM21 19V17C21 16.4 20.6 16 20 16H18V20H20C20.6 20 21 19.6 21 19ZM21 7V5C21 4.4 20.6 4 20 4H18V8H20C20.6 8 21 7.6 21 7Z" fill="currentColor" />
                            <path opacity="0.3" d="M17 22H3C2.4 22 2 21.6 2 21V3C2 2.4 2.4 2 3 2H17C17.6 2 18 2.4 18 3V21C18 21.6 17.6 22 17 22ZM10 7C8.9 7 8 7.9 8 9C8 10.1 8.9 11 10 11C11.1 11 12 10.1 12 9C12 7.9 11.1 7 10 7ZM13.3 16C14 16 14.5 15.3 14.3 14.7C13.7 13.2 12 12 10.1 12C8.10001 12 6.49999 13.1 5.89999 14.7C5.59999 15.3 6.19999 16 7.39999 16H13.3Z" fill="currentColor" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                    <h2>Agent Details</h2>
                </div>
                <!--end::Card title-->
                <!--begin::Card toolbar-->
                <div class="card-toolbar gap-3">
                   
                    <div class="badge badge-light-{{ $agent->user_status->color }}">{{ $agent->user_status->name }}</div>
                </div>
                <!--end::Card toolbar-->
            </div>
            <!--end::Card header-->
            <!--begin::Card body-->
            <div class="card-body pt-5">
                <!--begin::Profile-->
                <div class="d-flex gap-7 align-items-center">
                    <!--begin::Avatar-->
                    <div class="symbol symbol-circle symbol-100px">
                        <img src="{{ asset( 'media/avatars/'.$agent->avatar) }}" alt="image" />
                    </div>
                    <!--end::Avatar-->
                    <!--begin::Contact details-->
                    <div class="d-flex flex-column gap-2">
                        <!--begin::Name-->
                        <h3 class="mb-0">{{ $agent->name }} ({{ $agent->introducer_id }})</h3>
                        <!--end::Name-->
                        <!--begin::Email-->
                        <div class="d-flex align-items-center gap-2">
                            <!--begin::Svg Icon | path: icons/duotune/communication/com011.svg-->
                            <span class="svg-icon svg-icon-2">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.3" d="M21 19H3C2.4 19 2 18.6 2 18V6C2 5.4 2.4 5 3 5H21C21.6 5 22 5.4 22 6V18C22 18.6 21.6 19 21 19Z" fill="currentColor" />
                                    <path d="M21 5H2.99999C2.69999 5 2.49999 5.10005 2.29999 5.30005L11.2 13.3C11.7 13.7 12.4 13.7 12.8 13.3L21.7 5.30005C21.5 5.10005 21.3 5 21 5Z" fill="currentColor" />
                                </svg>
                            </span>
                            <!--end::Svg Icon-->
                            <a href="#" class="text-muted text-hover-primary">{{ $agent->email }}</a>
                        </div>
                        <!--end::Email-->
                        <!--begin::Phone-->
                        <div class="d-flex align-items-center gap-2">
                            <!--begin::Svg Icon | path: icons/duotune/electronics/elc003.svg-->
                            <span class="svg-icon svg-icon-2">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M5 20H19V21C19 21.6 18.6 22 18 22H6C5.4 22 5 21.6 5 21V20ZM19 3C19 2.4 18.6 2 18 2H6C5.4 2 5 2.4 5 3V4H19V3Z" fill="currentColor" />
                                    <path opacity="0.3" d="M19 4H5V20H19V4Z" fill="currentColor" />
                                </svg>
                            </span>
                            <!--end::Svg Icon-->
                            <a href="#" class="text-muted text-hover-primary">{{ $agent->phone_number }} </a>
                        </div>
                        <!--end::Phone-->
                    </div>
                    <!--end::Contact details-->
                </div>
                <!--end::Profile-->
                <!--begin:::Tabs-->
                <ul class="nav nav-custom nav-tabs nav-line-tabs nav-line-tabs-2x fs-6 fw-semibold mt-6 mb-8">
                    <!--begin:::Tab item-->
                    <li class="nav-item">
                        <a class="nav-link text-active-primary pb-4 active" data-bs-toggle="tab" href="#kt_contact_view_general">
                        <!--begin::Svg Icon | path: icons/duotune/general/gen001.svg-->
                        <span class="svg-icon svg-icon-4 me-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M11 2.375L2 9.575V20.575C2 21.175 2.4 21.575 3 21.575H9C9.6 21.575 10 21.175 10 20.575V14.575C10 13.975 10.4 13.575 11 13.575H13C13.6 13.575 14 13.975 14 14.575V20.575C14 21.175 14.4 21.575 15 21.575H21C21.6 21.575 22 21.175 22 20.575V9.575L13 2.375C12.4 1.875 11.6 1.875 11 2.375Z" fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->General</a>
                    </li>
                    <!--end:::Tab item-->
                    <!--begin:::Tab item-->
                    <li class="nav-item">
                        <a class="nav-link text-active-primary pb-4" data-bs-toggle="tab" href="#kt_contact_view_meetings">
                        <!--begin::Svg Icon | path: icons/duotune/general/gen014.svg-->
                        <span class="svg-icon svg-icon-4 me-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path opacity="0.3" d="M5 8.04999L11.8 11.95V19.85L5 15.85V8.04999Z" fill="currentColor"/>
                                <path d="M20.1 6.65L12.3 2.15C12 1.95 11.6 1.95 11.3 2.15L3.5 6.65C3.2 6.85 3 7.15 3 7.45V16.45C3 16.75 3.2 17.15 3.5 17.25L11.3 21.75C11.5 21.85 11.6 21.85 11.8 21.85C12 21.85 12.1 21.85 12.3 21.75L20.1 17.25C20.4 17.05 20.6 16.75 20.6 16.45V7.45C20.6 7.15 20.4 6.75 20.1 6.65ZM5 15.85V7.95L11.8 4.05L18.6 7.95L11.8 11.95V19.85L5 15.85Z" fill="currentColor"/>
                            </svg>
                        </span>
                        <!--end::Svg Icon-->Package</a>
                    </li>
                    <!--end:::Tab item-->
                    <!--begin:::Tab item-->
                    <li class="nav-item">
                        <a class="nav-link text-active-primary pb-4" data-bs-toggle="tab" href="#kt_contact_view_activity">
                        <!--begin::Svg Icon | path: icons/duotune/general/gen056.svg-->
                        <span class="svg-icon svg-icon-4 me-1">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M16.0173 9H15.3945C14.2833 9 13.263 9.61425 12.7431 10.5963L12.154 11.7091C12.0645 11.8781 12.1072 12.0868 12.2559 12.2071L12.6402 12.5183C13.2631 13.0225 13.7556 13.6691 14.0764 14.4035L14.2321 14.7601C14.2957 14.9058 14.4396 15 14.5987 15H18.6747C19.7297 15 20.4057 13.8774 19.912 12.945L18.6686 10.5963C18.1487 9.61425 17.1285 9 16.0173 9Z" fill="currentColor"/>
                                <rect opacity="0.3" x="14" y="4" width="4" height="4" rx="2" fill="currentColor"/>
                                <path d="M4.65486 14.8559C5.40389 13.1224 7.11161 12 9 12C10.8884 12 12.5961 13.1224 13.3451 14.8559L14.793 18.2067C15.3636 19.5271 14.3955 21 12.9571 21H5.04292C3.60453 21 2.63644 19.5271 3.20698 18.2067L4.65486 14.8559Z" fill="currentColor"/>
                                <rect opacity="0.3" x="6" y="5" width="6" height="6" rx="3" fill="currentColor"/>
                            </svg>
                        </span>
                        <!--end::Svg Icon-->Downline</a>
                    </li>
                    <!--end:::Tab item-->
                </ul>
                <!--end:::Tabs-->
                <!--begin::Tab content-->
                <div class="tab-content" id="">
                    <!--begin:::Tab pane-->
                    <div class="tab-pane fade show active" id="kt_contact_view_general" role="tabpanel">
                        <!--begin::Additional details-->
                        <div class="d-flex flex-column gap-5 mt-7">
                            <!--begin::City-->
                            <div class="d-flex flex-column gap-1">
                                <div class="fw-bold text-muted">My Sponsor</div>
                                <div class="fw-bold fs-5">{{ $parent[0]->name }}</div>
                            </div>
                            <!--end::City-->
                            <!--begin::City-->
                            <div class="d-flex flex-column gap-1">
                                <div class="fw-bold text-muted">NRIC Number</div>
                                <div class="fw-bold fs-5">{{ $agent->nric_number }}</div>
                            </div>
                            <!--end::City-->

                            <!--begin::Company name-->
                            <div class="d-flex flex-column gap-1">
                                <div class="fw-bold text-muted">Address</div>
                                <div class="fw-bold fs-5">{{ $agent->user_details->address }}, {{ $agent->user_details->city }} {{ $agent->user_details->postcode }}
                                        {{ $agent->user_details->state }}
                                </div>
                            </div>
                            <!--end::Company name-->
                           
                            <!--begin::Country-->
                            <div class="d-flex flex-column gap-1">
                                <div class="fw-bold text-muted">Bank</div>
                                <div class="fw-bold fs-5">{{ $agent->user_details->account_number }} ( {{ $agent->user_details->bank->name }} )</div>
                            </div>
                            <!--end::Country-->

                             <!--begin::Country-->
                             <div class="d-flex flex-column gap-1">
                                <div class="fw-bold text-muted">Beneficiary Name</div>
                                <div class="fw-bold fs-5">{{ $agent->user_details->beneficiary_name }}</div>
                            </div>
                            <!--end::Country-->
                            <!--begin::Notes-->
                           <!--  <div class="d-flex flex-column gap-1">
                                <div class="fw-bold text-muted">Notes</div>
                                <p>Emma Smith joined the team on September 2019 as a junior associate. She soon showcased her expertise and experience in knowledge and skill in the field, which was very valuable to the company. She was promptly promoted to senior associate on July 2020.
                                <br />
                                <br />Emma Smith now heads a team of 5 associates and leads the company's sales growth by 7%.</p>
                            </div> -->
                            <!--end::Notes-->
                        </div>
                        <!--end::Additional details-->
                    </div>
                    <!--end:::Tab pane-->
                    <!--begin:::Tab pane-->
                    <div class="tab-pane fade" id="kt_contact_view_meetings" role="tabpanel">
                        <!--begin::Table container-->
                        <div class="table-responsive">
                            <!--begin::Table-->
                            <table class="table align-middle gs-0 gy-4">
                                <!--begin::Table head-->
                                <thead>
                                    <tr class="fw-bold text-muted bg-light">
                                        <th class="ps-4 min-w-300px rounded-start">ABLV</th>
                                        <th class="text-center">MONTHLY ALLOWANCE</th>
                                        <th class="text-center">SHAREHOLDER IN PFD INT BHD</th>
                                        <th class="text-center">DISCOUNT ON GOLD</th>
                                        <th class="text-center">CONTRACT</th>
                                        <th class="min-w-200px text-center rounded-end">ABLA</th>
                                    </tr>
                                </thead>
                                <!--end::Table head-->
                                <!--begin::Table body-->
                                <tbody>
                                    @foreach($packages as $package)
                                        @if($package->id == $agent->package_id)
                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center me-3">
                                                        <div class="d-flex justify-content-start flex-column">
                                                            <a href="#" class="text-dark fw-bold text-hover-primary fs-6">{{ $package->position }}</a>
                                                            <span class="text-muted fw-semibold text-muted d-block fs-7">{{ $package->iso }}</span>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <a href="#" class="text-dark fw-bold text-hover-primary d-block fs-6">RM {{ formatMoney($package->ablv_rm,1) }}</a>
                                                </td>
                                                <td class="text-center">
                                                    @foreach($package->allowances as $allowance)
                                                        @if($allowance->allowance_percent == 100)
                                                            <a href="#" class="text-dark text-hover-primary d-block fs-6">{{ $allowance->allowance_type }}</a>
                                                        @else
                                                            <a href="#" class="text-dark text-hover-primary d-block fs-6">{{ $allowance->allowance_type }}:{{ formatMoney($allowance->allowance_percent,1) }}%</a>
                                                            
                                                        @endif
                                                        
                                                    @endforeach
                                                </td>
                                                <td class="text-center">
                                                    @if($package->shareholder_rm == null)
                                                        -
                                                    @else
                                                        RM {{ formatMoney($package->shareholder_rm,1) }}
                                                    @endif
                                                </td>
                                                <td class="text-center">
                                                    @if($package->discount_percent == null)
                                                        -
                                                    @else
                                                        {{ formatMoney($package->discount_percent,1) }}%
                                                    @endif
                                                </td>
                                                <td class="text-center">
                                                    @if($order->order_status_id == 2)
                                                        <a href="#" class="text-dark fw-bold text-hover-primary d-block fs-6">RM {{ formatMoney($order->abla_amt,1) }}</a>
                                                    @else
                                                        <div class="badge badge-light-{{$order->order_status->color}}">{{$order->order_status->name}}'</div>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                  
                                </tbody>
                                <!--end::Table body-->
                            </table>
                            <!--end::Table-->
                        </div>
                        <!--end::Table container-->
                       
        
                    </div>
                    <!--end:::Tab pane-->
                    <!--begin:::Tab pane-->
                    <div class="tab-pane fade" id="kt_contact_view_activity" role="tabpanel">
                        <!--begin::Table container-->
                        <div class="table-responsive">
                            <!--begin::Table-->
                            <table class="table table-row-dashed table-row-gray-300 align-middle gs-0 gy-4">
                                <!--begin::Table head-->
                                <thead>
                                    <tr class="fw-bold text-muted">
                                       
                                        <th class="min-w-200px">Agent</th>
                                        <th class="min-w-150px">Package</th>
                                        <th class="min-w-150px"></th>
                                        <th class="min-w-100px text-end">Actions</th>
                                    </tr>
                                </thead>
                                <!--end::Table head-->
                                <!--begin::Table body-->
                                <tbody>
                                    @if(count($downlines) > 0)
                                        @foreach($downlines as $downline)

                                            <tr>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="symbol symbol-45px me-5">
                                                            <img src="{{ asset( 'media/avatars/'.$downline->user->avatar) }}" alt="" />
                                                        </div>
                                                        <div class="d-flex justify-content-start flex-column">
                                                            <a href="#" class="text-dark fw-bold text-hover-primary fs-6">{{ $downline->user->name }}</a>
                                                            <span class="text-muted fw-semibold text-muted d-block fs-7">{{ $downline->user->phone_number }}</span>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <a href="#" class="text-dark fw-bold text-hover-primary d-block fs-6">{{ $downline->user->package->position }}</a>
                                                    <span class="text-muted fw-semibold text-muted d-block fs-7">{{ $downline->user->package->iso }}</span> 
                                                </td>
                                                <td class="text-end">
                                                    <!-- <div class="d-flex flex-column w-100 me-2">
                                                        <div class="d-flex flex-stack mb-2">
                                                            <span class="text-muted me-2 fs-7 fw-bold">50%</span>
                                                        </div>
                                                        <div class="progress h-6px w-100">
                                                            <div class="progress-bar bg-primary" role="progressbar" style="width: 50%" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
                                                        </div>
                                                    </div> -->
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-end flex-shrink-0">
                                                        <a href="{{ route('show-agent', $downline->user->id) }}" class="btn btn-icon btn-bg-light btn-active-color-primary btn-sm me-1">
                                                            <!--begin::Svg Icon | path: icons/duotune/general/gen019.svg-->
                                                            <span class="svg-icon svg-icon-3">
                                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                                        <rect x="0" y="0" width="24" height="24"/>
                                                                        <path d="M3,12 C3,12 5.45454545,6 12,6 C16.9090909,6 21,12 21,12 C21,12 16.9090909,18 12,18 C5.45454545,18 3,12 3,12 Z" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
                                                                        <path d="M12,15 C10.3431458,15 9,13.6568542 9,12 C9,10.3431458 10.3431458,9 12,9 C13.6568542,9 15,10.3431458 15,12 C15,13.6568542 13.6568542,15 12,15 Z" fill="#000000" opacity="0.3"/>
                                                                    </g>
                                                                </svg>
                                                            </span>
                                                            <!--end::Svg Icon-->
                                                        </a>
                                                    
                                                    </div>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @else
                                    <tr><td colspan="4" class="text-center">No Downline</td></tr>
                                    @endif
                                    
                                </tbody>
                                <!--end::Table body-->
                            </table>
                            <!--end::Table-->
                        </div>
                        <!--end::Table container-->
                        
                    </div>
                    <!--end:::Tab pane-->
                </div>
                <!--end::Tab content-->
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Contacts-->
    </div>
</div>

@endsection