{{-- Extends layout --}}
@extends('index')

{{-- Content --}}
@section('content')
<!--begin::Toolbar-->
<div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
    <!--begin::Toolbar container-->
    <div id="kt_app_toolbar_container" class="app-container container-xxl d-flex flex-stack">
        <!--begin::Page title-->
        <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
            <!--begin::Title--> 
            <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">Edit User</h1>
            <!--end::Title-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('dashboard') }}" class="text-muted text-hover-primary">Home</a>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-400 w-5px h-2px"></span>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">User Management</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
         <!--begin::Actions-->
         <div class="d-flex align-items-center gap-2 gap-lg-3">
            <!--begin::Button-->
            <a href="{{ route('index-user') }}" class="btn btn-secondary btn-sm ms-auto">
                <!--begin::Svg Icon | path: icons/duotune/arrows/arr074.svg-->
                <span class="svg-icon svg-icon-2">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.2657 11.4343L15.45 7.25C15.8642 6.83579 15.8642 6.16421 15.45 5.75C15.0358 5.33579 14.3642 5.33579 13.95 5.75L8.40712 11.2929C8.01659 11.6834 8.01659 12.3166 8.40712 12.7071L13.95 18.25C14.3642 18.6642 15.0358 18.6642 15.45 18.25C15.8642 17.8358 15.8642 17.1642 15.45 16.75L11.2657 12.5657C10.9533 12.2533 10.9533 11.7467 11.2657 11.4343Z" fill="currentColor" />
                    </svg>
                </span> Back
                <!--end::Svg Icon-->
            </a>
            <!--end::Button-->

           
        </div>
        <!--end::Actions-->
       
    </div>
    <!--end::Toolbar container-->
</div>
<!--end::Toolbar-->

<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
        <!--begin::Basic info-->
        <div class="card mb-5 mb-xl-10">
            <!--begin::Card header-->
            <div class="card-header border-0 cursor-pointer" role="button" data-bs-toggle="collapse" data-bs-target="#kt_account_profile_details" aria-expanded="true" aria-controls="kt_account_profile_details">
                <!--begin::Card title-->
                <div class="card-title m-0">
                    <h3 class="fw-bold m-0">User Details</h3>
                </div>
                <!--end::Card title-->
            </div>
            <!--begin::Card header-->
            <!--begin::Content-->
            <div id="kt_account_settings_profile_details" class="collapse show">
                <!--begin::Form-->
                <form action="{{ route('update-user', $user->id)}}" method="POST" id="kt_account_profile_details_form" class="form">
                @csrf 
    
                    @if(session('success')) 
                    <script>
                    $(document).ready(function(){
                        swal.fire({
                            title: "DONE!",
                            text: "{{ session('success') }}",
                            icon: "success",
                            timer: 2500,
                            showConfirmButton: false
                        });
                    });
                    
                    </script> 
                    @endif

                    @if ($errors->any())
                        <script>
                        $(document).ready(function(){
                            swal.fire({
                                title: "Warning!",
                                text: "Please check your input.",
                                icon: "warning",
                                timer: 2500,
                                showConfirmButton: false
                            });
                        });
                        
                        </script> 
                    @endif
                    <!--begin::Card body-->
                    <div class="card-body border-top p-9">
                    
            
                        <!--begin::Input group-->
                        <div class="row mb-6">
                            <!--begin::Label-->
                            <label class="col-lg-4 col-form-label required fw-semibold fs-6">Full Name</label>
                            <!--end::Label-->
                            <!--begin::Col-->
                            <div class="col-lg-8">
                                <!--begin::Row-->
                                <div class="row">
                                    <!--begin::Col-->
                                    <div class="col-lg-12 fv-row">
                                        <input type="text" name="name" class="form-control form-control-lg @error('name') is-invalid @enderror form-control-solid mb-3 mb-lg-0" placeholder="First name" 
                                            value="{{ old('name', $user->name) }}" />

                                        @error('name')
                                            <div class="text-danger">{{$message}}</div>
                                        @enderror
                                    </div>
                                    <!--end::Col-->
                                </div>
                                <!--end::Row-->
                            </div>
                            <!--end::Col-->
                        </div>
                        <!--end::Input group-->
                        <!--begin::Input group-->
                        <div class="row mb-6">
                            <!--begin::Label-->
                            <label class="col-lg-4 col-form-label required fw-semibold fs-6">NRIC Number</label>
                            <!--end::Label-->
                            <!--begin::Col-->
                            <div class="col-lg-8 fv-row">
                                <input type="text" name="nric_number" class="form-control form-control-lg @error('nric_number') is-invalid @enderror form-control-solid" placeholder="NRIC Number" 
                                    oninput="this.value = this.value.replace(/[^0-9]/g, '').replace(/(\..*?)\..*/g, '$1');" value="{{ $user->nric_number }}" />
                                
                                @error('nric_number')
                                    <div class="text-danger">{{$message}}</div>
                                @enderror
                            </div>
                            <!--end::Col-->
                        </div>
                        <!--end::Input group-->
                        <!--begin::Input group-->
                        <div class="row mb-6">
                            <!--begin::Label-->
                            <label class="col-lg-4 col-form-label fw-semibold fs-6">
                                <span class="required">Contact Phone</span>
                                <i class="fas fa-exclamation-circle ms-1 fs-7" data-bs-toggle="tooltip" title="Phone number must be active"></i>
                            </label>
                            <!--end::Label-->
                            <!--begin::Col-->
                            <div class="col-lg-8 fv-row">
                                <input type="tel" name="phone_number" class="form-control form-control-lg @error('phone_number') is-invalid @enderror form-control-solid" placeholder="Phone number" 
                                    value="{{ $user->phone_number }}" />

                                @error('phone_number')
                                    <div class="text-danger">{{$message}}</div>
                                @enderror
                            </div>
                            <!--end::Col-->
                        </div>
                        <!--end::Input group-->
                    <!--begin::Input group-->
                    <div class="row mb-6">
                        <!--begin::Label-->
                        <label class="col-lg-4 col-form-label fw-semibold fs-6 required">E-mail</label>
                        <!--end::Label-->
                        <!--begin::Col-->
                        <div class="col-lg-8 fv-row">
                            <input
                                class="form-control @error('email') is-invalid @enderror form-control-solid "
                                type="text" placeholder="email" name="email" autocomplete="off"
                                value="{{ old('email', $user->email) }}" /> 

                            @error('email')
                                <div class="text-danger">{{$message}}</div>
                            @enderror
                        </div>
                        <!--end::Col-->
                    </div>
                    <!--end::Input group-->
                    <div class="form-group row mb-6">
                        <label class="col-lg-4 col-form-label fw-bold fs-6">Address</label>
                        <div class="col-lg-8 fv-row">
                            <input
                                class="form-control @error('address') is-invalid @enderror form-control-solid"
                                type="text" placeholder="Address" name="address"
                                autocomplete="off" value="{{ old('address', $user->user_details->address) }}" />
                            @error('address')
                                <div class="text-danger">{{$message}}</div>
                            @enderror
                        </div>
                    </div>
                    
                
                    
                    <div class="form-group row mb-6">
                        <label class="col-lg-4 col-form-label fw-bold fs-6">Postcode</label>
                        <div class="col-lg-8 fv-row">
                            <input
                                class="form-control @error('postcode') is-invalid @enderror form-control-solid"
                                type="number" pattern="[0-9]" placeholder="Postcode" name="postcode"
                                autocomplete="off" value="{{ old('postcode', $user->user_details->postcode) }}" />
                            @error('postcode')
                                <div class="text-danger">{{$message}}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="form-group row mb-6">
                        <label class="col-lg-4 col-form-label fw-bold fs-6">City</label>
                        <div class="col-lg-8 fv-row">
                            <input
                                class="form-control @error('city') is-invalid @enderror form-control-solid "
                                type="text" placeholder="city" name="city" autocomplete="off"
                                value="{{ old('city', $user->user_details->city) }}" /> 
                            @error('city')
                                <div class="text-danger">{{$message}}</div>
                            @enderror
                            
                        </div>
                    </div>
                    <div class="form-group row mb-6">
                        <label class="col-lg-4 col-form-label fw-bold fs-6">State</label>
                        <div class="col-lg-8 fv-row">
                            <select name="state" id="state" class="form-control @error('state') is-invalid @enderror form-control-solid" 
                                data-control="select2" data-placeholder="Select..." data-allow-clear="false" data-hide-search="true">
                                <option></option>

                                @foreach($states as $negeri)
                                    <option value="{{ $negeri->name }}" {{old('negeri', $user->user_details->state)==$negeri->name ? 'selected' : ''}}>{{ $negeri->name }}</option>
                                @endforeach
                            </select>
                            
                            @error('state')
                                <div class="text-danger">{{$message}}</div>
                            @enderror
                            
                        </div>
                    </div>
                </div>
                <!--end::Card body-->
                <!--begin::Actions-->
                <div class="card-footer d-flex justify-content-end py-6 px-9">
                    <button type="reset" class="btn btn-light btn-active-light-primary me-2">Discard</button>
                    <button type="submit" class="button btn btn-primary" id="kt_account_profile_details_submit"
                        onclick="this.classList.toggle('button--loading')">
                        <span class="button__text">Save Changes</span></button>
                </div>
                <!--end::Actions-->
            </form>
            <!--end::Form-->
            </div>
            <!--end::Content-->
        </div>
        <!--end::Basic info-->
    </div>
</div>

@endsection