<?php $__env->startSection('content'); ?>

<!--begin::Toolbar-->
<div id="kt_app_toolbar" class="app-toolbar py-3 py-lg-6">
    <!--begin::Toolbar container-->
    <div id="kt_app_toolbar_container" class="app-container container-xxl d-flex flex-stack">
        <!--begin::Page title-->
        <div class="page-title d-flex flex-column justify-content-center flex-wrap me-3">
            <!--begin::Title--> 
            <h1 class="page-heading d-flex text-dark fw-bold fs-3 flex-column justify-content-center my-0">Dashboard</h1>
            <!--end::Title-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0 pt-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="<?php echo e(route('dashboard')); ?>" class="text-muted text-hover-primary">Home</a>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-400 w-5px h-2px"></span>
                </li>
                <!--end::Item-->
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">Dashboard</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
        <!--begin::Actions-->
        <div class="d-flex align-items-center gap-2 gap-lg-3">
            <!--begin::Button-->
            <a href="<?php echo e(route('show-order', $order->id)); ?>" class="btn btn-secondary btn-sm ms-auto">
                <!--begin::Svg Icon | path: icons/duotune/arrows/arr074.svg-->
                <span class="svg-icon svg-icon-2">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.2657 11.4343L15.45 7.25C15.8642 6.83579 15.8642 6.16421 15.45 5.75C15.0358 5.33579 14.3642 5.33579 13.95 5.75L8.40712 11.2929C8.01659 11.6834 8.01659 12.3166 8.40712 12.7071L13.95 18.25C14.3642 18.6642 15.0358 18.6642 15.45 18.25C15.8642 17.8358 15.8642 17.1642 15.45 16.75L11.2657 12.5657C10.9533 12.2533 10.9533 11.7467 11.2657 11.4343Z" fill="currentColor" />
                    </svg>
                </span> Back
                <!--end::Svg Icon-->
            </a>
            <!--end::Button-->

           
        </div>
        <!--end::Actions-->
       
    </div>
    <!--end::Toolbar container-->
</div>
<!--end::Toolbar-->

<!--begin::Content-->
<div id="kt_app_content" class="app-content flex-column-fluid">
	<!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
        <!--begin::Tables Widget 9-->
        <div class="card mb-5 mb-xl-8">
            <!--begin::Header-->
            <div class="card-header border-0 pt-5">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bold fs-3 mb-1">Agent/Advisor Package</span>
                    <span class="text-muted mt-1 fw-semibold fs-7">Please reselect Package</span>
                </h3>
       
            </div>
            <!--end::Header-->
            <!--begin::Body-->
            <div class="card-body py-3">
                <!--begin::Table container-->
                <div class="table-responsive" id="errorScrollDiv">
                    <!--begin::Table-->
                    <table class="table table-row-dashed table-row-gray-300 align-middle gs-0 gy-4" id ="table_id">
                        <!--begin::Table head-->
                        <thead>
                            <tr class="fw-bold text-muted">
                                <th class="w-25px">
                                    <!-- <div class="form-check form-check-sm form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" value="1" data-kt-check="true" data-kt-check-target=".widget-9-check" />
                                    </div> -->
                                </th>
                                <th>POSITION</th>
                                <th>ABLV</th>
                                <th>MONTHLY ALLOWANCE (10%  - 25% )</th>
                                <th>SHAREHOLDER IN PFD INT BHD</th>
                                <th>DISCOUNT ON GOLD (E-GOLD)</th>
                                <th>CONTRACT</th>
                                <th>LEGAL FEE</th>
                            </tr>
                        </thead>
                        <!--end::Table head-->
                        <!--begin::Table body-->
                        <tbody>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                <td>
                                    <label class="form-check form-check-custom form-check-solid me-5">
                                        <input class="form-check-input" type="radio" name="package" 
                                        value="<?php echo e($package->id); ?>"
                                        <?php echo e($reselect_package==$package->id ? 'checked' : ''); ?>/>
                                    </label>
                                </td>
                                <td >
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex justify-content-start flex-column">
                                            <a href="#" class="text-dark fw-bold text-hover-primary fs-6"><?php echo e($package->position); ?></a>
                                            <span class="text-muted fw-semibold text-muted d-block fs-7"><?php echo e($package->iso); ?></span>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <a href="#" class="text-dark text-hover-primary d-block fs-6">RM <?php echo e(formatMoney($package->ablv_rm,1)); ?></a>
                                </td>
                                <td class="text-center">
                                    <?php $__currentLoopData = $package->allowances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($allowance->allowance_percent == 100): ?>
                                            <a href="#" class="text-dark text-hover-primary d-block fs-6"><?php echo e($allowance->allowance_type); ?></a>
                                        <?php else: ?>
                                            <a href="#" class="text-dark text-hover-primary d-block fs-6"><?php echo e($allowance->allowance_type); ?>:<?php echo e(formatMoney($allowance->allowance_percent,1)); ?>%</a>
                                           
                                        <?php endif; ?>
                                        
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 
                                </td>
                                <td class="text-center">
                                    <?php if($package->shareholder_rm == null): ?>
                                        -
                                    <?php else: ?>
                                        RM <?php echo e(formatMoney($package->shareholder_rm,1)); ?>

                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php if($package->discount_percent == null): ?>
                                        -
                                    <?php else: ?>
                                        <?php echo e(formatMoney($package->discount_percent,1)); ?>%
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php echo e($package->contract); ?>

                                </td>
                            
                                <td class="text-center">
                                    <?php if($package->legal_fee_rm == null): ?>
                                        -
                                    <?php else: ?>
                                        RM <?php echo e(formatMoney($package->legal_fee_rm,1)); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        </tbody>
                        <!--end::Table body-->
                    </table>
                    <!--end::Table-->
                </div>
                <!--end::Table container-->
                
            </div>
            <!--begin::Body-->
            
        </div>
        <!--end::Tables Widget 9-->

        <div class="d-flex justify-content-end">
            <!--begin::Button-->
            <a href="<?php echo e(route('show-order', $order->id)); ?>" id="kt_ecommerce_edit_order_cancel" class="btn btn-light me-5">Cancel</a>
            <!--end::Button-->
            <!--begin::Button-->
            <button type="submit" id="btn_next_package" class="button btn btn-primary"
                onclick="this.classList.toggle('button--loading')">
                <span class="button__text">Next</span>
            </button>
            <!--end::Button-->
        </div>
    </div>
</div>
       
<?php $__env->stopSection(); ?>



<?php $__env->startSection('scripts'); ?>
 
<script>

$('#btn_next_package').on('click',function() {

    if( $('[name=package]').is(':checked') ){

        var package = $("[name=package]:checked").val();
        $.ajax({
            url: "<?php echo e(route('next-order', $order->id)); ?>", 
            type:"POST",
            data:{
                "_token": "<?php echo e(csrf_token()); ?>",
                package:package,
            },
            success:function(response){
                $("#btn_next_package").removeClass('button--loading');

                console.log(response);
                if(response.success)
                {
                    location.href = "<?php echo e(route('edit-payment-order', $order->id)); ?>"
                }
            
            }
        });  
    }
    else{
        $("#btn_next_package").removeClass('button--loading');

        swal.fire({
            title: "Warning!",
            text: "Please select package",
            icon: "warning",
            timer: 2500,
            showConfirmButton: false
        }).then(function() {
            $('html, body').animate({
                scrollTop: $("#errorScrollDiv").offset()
                    .top - 130
            }, 1000);
        });
    }
        
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\pfdib-system\resources\views/order/edit-reselect-package.blade.php ENDPATH**/ ?>