


    <?php if(Auth::user()->package_id == 0): ?>
        <!--begin::Tables Widget 9-->
        <div class="card mb-5 mb-xl-8">
            <!--begin::Header-->
            <div class="card-header border-0 pt-5">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bold fs-3 mb-1">Agent/Advisor Package</span>
                    <span class="text-muted mt-1 fw-semibold fs-7">Please select Package</span>
                </h3>
                <!-- <div class="card-toolbar" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-trigger="hover" title="Click to add a user">
                    <a href="#" class="btn btn-sm btn-light btn-active-primary" data-bs-toggle="modal" data-bs-target="#kt_modal_invite_friends">
                
                    <span class="svg-icon svg-icon-3">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect opacity="0.5" x="11.364" y="20.364" width="16" height="2" rx="1" transform="rotate(-90 11.364 20.364)" fill="currentColor" />
                            <rect x="4.36396" y="11.364" width="16" height="2" rx="1" fill="currentColor" />
                        </svg>
                    </span>New Member</a>
                </div> -->
            </div>
            <!--end::Header-->
            <!--begin::Body-->
            <div class="card-body py-3">
                <!--begin::Table container-->
                <div class="table-responsive" id="errorScrollDiv">
                    <!--begin::Table-->
                    <table class="table table-row-dashed table-row-gray-300 align-middle gs-0 gy-4" id ="table_id">
                        <!--begin::Table head-->
                        <thead>
                            <tr class="fw-bold text-muted">
                                <th class="w-25px">
                                    <!-- <div class="form-check form-check-sm form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" value="1" data-kt-check="true" data-kt-check-target=".widget-9-check" />
                                    </div> -->
                                </th>
                                <th>POSITION</th>
                                <th>ABLV</th>
                                <th>MONTHLY ALLOWANCE (10%  - 25% )</th>
                                <th>SHAREHOLDER IN PFD INT BHD</th>
                                <th>DISCOUNT ON GOLD (E-GOLD)</th>
                                <th>CONTRACT</th>
                                <th>LEGAL FEE</th>
                            </tr>
                        </thead>
                        <!--end::Table head-->
                        <!--begin::Table body-->
                        <tbody>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                <td>
                                    <label class="form-check form-check-custom form-check-solid me-5">
                                        <input class="form-check-input" type="radio" name="package" value="<?php echo e($package->id); ?>"/>
                                    </label>
                                    <!-- <div class="form-check form-check-sm form-check-custom form-check-solid">
                                        <input class="form-check-input widget-9-check" type="radio" value="1" />
                                    </div> -->
                                </td>
                                <td >
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex justify-content-start flex-column">
                                            <a href="#" class="text-dark fw-bold text-hover-primary fs-6"><?php echo e($package->position); ?></a>
                                            <span class="text-muted fw-semibold text-muted d-block fs-7"><?php echo e($package->iso); ?></span>
                                        </div>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <a href="#" class="text-dark text-hover-primary d-block fs-6">RM <?php echo e(formatMoney($package->ablv_rm,1)); ?></a>
                                </td>
                                <td class="text-center">
                                    <?php $__currentLoopData = $package->allowances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($allowance->allowance_percent == 100): ?>
                                            <a href="#" class="text-dark text-hover-primary d-block fs-6"><?php echo e($allowance->allowance_type); ?></a>
                                        <?php else: ?>
                                            <a href="#" class="text-dark text-hover-primary d-block fs-6"><?php echo e($allowance->allowance_type); ?>:<?php echo e(formatMoney($allowance->allowance_percent,1)); ?>%</a>
                                           
                                        <?php endif; ?>
                                        
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 
                                </td>
                                <td class="text-center">
                                    <?php if($package->shareholder_rm == null): ?>
                                        -
                                    <?php else: ?>
                                        RM <?php echo e(formatMoney($package->shareholder_rm,1)); ?>

                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php if($package->discount_percent == null): ?>
                                        -
                                    <?php else: ?>
                                        <?php echo e(formatMoney($package->discount_percent,1)); ?>%
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <?php echo e($package->contract); ?>

                                </td>
                            
                                <td class="text-center">
                                    <?php if($package->legal_fee_rm == null): ?>
                                        -
                                    <?php else: ?>
                                        RM <?php echo e(formatMoney($package->legal_fee_rm,1)); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        </tbody>
                        <!--end::Table body-->
                    </table>
                    <!--end::Table-->
                </div>
                <!--end::Table container-->
                
            </div>
            <!--begin::Body-->
        </div>
        <!--end::Tables Widget 9-->
        <div class="card-footer d-flex justify-content-end ">
    
            <button type="button" class="button btn btn-primary" id="btn_submit_package"
                onclick="this.classList.toggle('button--loading')">
                <span class="button__text">Buy Package</span>
            </button>
        </div>
    <?php else: ?> 
    <div class="row g-7 mb-5">
        <!--begin::Content-->
        <div class="col-xl-12">
            <!--begin::Contacts-->
            <div class="card card-flush h-lg-100" id="kt_contacts_main">
                <!--begin::Card header-->
                <div class="card-header pt-7" id="kt_chat_contacts_header">
                    <!--begin::Card title-->
                    <div class="card-title">
                   
                        <h2>Sponsor Details</h2>
                    </div>
                    <!--end::Card title-->
                   
                </div>
                <!--end::Card header-->
                <!--begin::Card body-->
                <div class="card-body pt-5">
                    <!--begin::Profile-->
                    <div class="d-flex gap-7 align-items-center">
                        <!--begin::Avatar-->
                        <div class="symbol symbol-circle symbol-100px">
                            <img src="<?php echo e(asset('media/avatars/'.$parent[0]->avatar)); ?>" alt="image" />
                        </div>
                        <!--end::Avatar-->
                        <!--begin::Contact details-->
                        <div class="d-flex flex-column gap-2">
                            <!--begin::Name-->
                            <h3 class="mb-0"><?php echo e($parent[0]->name); ?></h3>
                            <!--end::Name-->
                            <!--begin::Email-->
                            <div class="d-flex align-items-center gap-2">
                                <!--begin::Svg Icon | path: icons/duotune/communication/com011.svg-->
                                <span class="svg-icon svg-icon-2">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path opacity="0.3" d="M21 19H3C2.4 19 2 18.6 2 18V6C2 5.4 2.4 5 3 5H21C21.6 5 22 5.4 22 6V18C22 18.6 21.6 19 21 19Z" fill="currentColor" />
                                        <path d="M21 5H2.99999C2.69999 5 2.49999 5.10005 2.29999 5.30005L11.2 13.3C11.7 13.7 12.4 13.7 12.8 13.3L21.7 5.30005C21.5 5.10005 21.3 5 21 5Z" fill="currentColor" />
                                    </svg>
                                </span>
                                <!--end::Svg Icon-->
                                <a href="#" class="text-muted text-hover-primary"><?php echo e($parent[0]->email); ?></a>
                            </div>
                            <!--end::Email-->
                            <!--begin::Phone-->
                            <div class="d-flex align-items-center gap-2">
                                <!--begin::Svg Icon | path: icons/duotune/electronics/elc003.svg-->
                                <span class="svg-icon svg-icon-2">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M5 20H19V21C19 21.6 18.6 22 18 22H6C5.4 22 5 21.6 5 21V20ZM19 3C19 2.4 18.6 2 18 2H6C5.4 2 5 2.4 5 3V4H19V3Z" fill="currentColor" />
                                        <path opacity="0.3" d="M19 4H5V20H19V4Z" fill="currentColor" />
                                    </svg>
                                </span>
                                <!--end::Svg Icon-->
                                <a href="#" class="text-muted text-hover-primary"><?php echo e($parent[0]->phone_number); ?></a>
                            </div>
                            <!--end::Phone-->
                        </div>
                        <!--end::Contact details-->
                    </div>
                    <!--end::Profile-->
                  
                </div>
                <!--end::Card body-->
            </div>
            <!--end::Contacts-->
        </div>
        <!--end::Content-->
    </div>

    <!--begin::Tables Widget 9-->
    <div class="card mb-5 mb-xl-8">
        <!--begin::Header-->
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bold fs-3 mb-1">My Package</span>
               <!--  <span class="text-muted mt-1 fw-semibold fs-7">Please select Package</span> -->
            </h3>
        </div>
        <!--end::Header-->
        <!--begin::Body-->
        <div class="card-body py-3">
            <!--begin::Table container-->
            <div class="table-responsive" id="errorScrollDiv">
                <!--begin::Table-->
                <table class="table table-row-dashed table-row-gray-300 align-middle gs-0 gy-4" id ="table_id">
                    <!--begin::Table head-->
                    <thead>
                        <tr class="fw-bold text-muted">
                         
                            <th >POSITION</th>
                            <th class="text-center">ABLV</th>
                            <th class="text-center">MONTHLY ALLOWANCE</th>
                            <th class="text-center">SHAREHOLDER IN PFD INT BHD</th>
                            <th class="text-center">DISCOUNT ON GOLD</th>
                            <th class="text-center">CONTRACT</th>
                            <th class="text-center">ABLA</th>
                        </tr>
                    </thead>
                    <!--end::Table head-->
                    <!--begin::Table body-->
                    <tbody>
                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($package->id == $agent->package_id): ?>
                                <tr>
                         
                                    <td >
                                        <div class="d-flex align-items-center">
                                            <div class="d-flex justify-content-start flex-column">
                                                <a href="#" class="text-dark fw-bold text-hover-primary fs-6"><?php echo e($package->position); ?></a>
                                                <span class="text-muted fw-semibold text-muted d-block fs-7"><?php echo e($package->iso); ?></span>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <a href="#" class="text-dark fw-bold text-hover-primary d-block fs-6">RM <?php echo e(formatMoney($package->ablv_rm,1)); ?></a>
                                    </td>
                                    <td class="text-center">
                                        <?php $__currentLoopData = $package->allowances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allowance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($allowance->allowance_percent == 100): ?>
                                                <a href="#" class="text-dark text-hover-primary d-block fs-6"><?php echo e($allowance->allowance_type); ?></a>
                                            <?php else: ?>
                                                <a href="#" class="text-dark text-hover-primary d-block fs-6"><?php echo e($allowance->allowance_type); ?>:<?php echo e(formatMoney($allowance->allowance_percent,1)); ?>%</a>
                                                
                                            <?php endif; ?>
                                            
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        
                                    </td>
                                    <td class="text-center">
                                        <?php if($package->shareholder_rm == null): ?>
                                            -
                                        <?php else: ?>
                                            RM <?php echo e(formatMoney($package->shareholder_rm,1)); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php if($package->discount_percent == null): ?>
                                            -
                                        <?php else: ?>
                                            <?php echo e(formatMoney($package->discount_percent,1)); ?>%
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <?php echo e($package->contract); ?>

                                    </td>
                                
                                    <td class="text-center">
                                        <?php if($order->order_status_id == 2): ?>
                                            <a href="#" class="text-dark fw-bold text-hover-primary d-block fs-6">RM <?php echo e(formatMoney($order->abla_amt,1)); ?></a>
                                        <?php else: ?>
                                            <div class="badge badge-light-<?php echo e($order->order_status->color); ?>"><?php echo e($order->order_status->name); ?>'</div>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                    </tbody>
                    <!--end::Table body-->
                </table>
                <!--end::Table-->
            </div>
            <!--end::Table container-->
            
        </div>
        <!--begin::Body-->
    </div>
    <!--end::Tables Widget 9-->

    <?php endif; ?>





<?php $__env->startSection('scripts'); ?>
 
<script>
 
 
$('#btn_submit_package').on('click',function() {

    if( $('[name=package]').is(':checked') ){
        event.preventDefault();
        swal.fire({
            title: "Are you sure?",
            text: 'This action will submit the form.',
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, confirm!',
        })
        .then((result) => {
            if (result.isConfirmed) {
                var package = $("[name=package]:checked").val();
               
                $.ajax({
                    url: "<?php echo e(route('buy-package')); ?>", 
                    type:"POST",
                    data:{
                        "_token": "<?php echo e(csrf_token()); ?>",
                        package:package,
                    },
                    success:function(response){
                        $("#btn_submit_package").removeClass('button--loading');

                        console.log(response);
                        if(response.success)
                        {
                            swal.fire({
                                title: "DONE!",
                                text: response.success,
                                icon: "success",
                            }).then(function() {
                                location.reload();
                            });
                        }
                    
                    }
                });  
            }
            else
            {
                $("#btn_submit_package").removeClass('button--loading');
            }
        }); 
    }
    else{
        $("#btn_submit_package").removeClass('button--loading');

        swal.fire({
            title: "Warning!",
            text: "Please select package",
            icon: "warning",
            timer: 2500,
            showConfirmButton: false
        }).then(function() {
            $('html, body').animate({
                scrollTop: $("#errorScrollDiv").offset()
                    .top - 130
            }, 1000);
        });
    }
            
});

</script>
<?php $__env->stopSection(); ?><?php /**PATH C:\laragon\www\pfdib-system\resources\views/dashboard/agent.blade.php ENDPATH**/ ?>